%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Ce script montre l'utilisation de deux fonctions Matlab 
%%%% pour generer le diagramme de Voronoi d'un environnement Q  
%%%% a partir de n generateurs (points 2D distribues de façon aleatoire)
%%%%
%%%% 1) La fonction "mpt_voronoi(.,.)" utilise la programmation lineaire
%%%% multi-parametrique via le Multi-Parametric Toolbox (MPT)
%%%% http://control.ee.ethz.ch/~mpt/downloads/
%%%% (avant de lancer, executer le script "install_mpt3.m"),
%%%% pour determiner les regions V1,...,Vn du diagramme de Voronoi
%%%%
%%%% 2) La fonction "voronoi(.,.)" construit aussi le diagramme de Voronoi,
%%%% mais la frontiere de l'environnement Q a partitionner ne peut pas 
%%%% etre specifiee comme dans "mpt_voronoi(.,.)". "voronoi(.,.)" est 
%%%% une fonction standard de Matlab 
%%%%                                                          
%%%% Author: Fabio Morbidi                                    
%%%% Decembre 2018

close all
clear 
clc

n = 50; %% Nombre de generateurs du diagramme de Voronoi 

mu = [0.9 0.3];
Sigma = [0.21 0;0 0.21]; 
R = chol(Sigma);

%%% Les generateurs sont des points aleatoires tires d'une pdf gaussienne
%%% bivariee avec moyenne 'mu' et matrice de covariance 'Sigma'

points = repmat(mu,n,1) + randn(n,2)*R; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Utilisation de la fonction "mpt_voronoi" du Multi-Parametric Toolbox %%%

%%% Definition de l'environnement Q (polyedre) que nous voulons partitionner: 
%%% ici, une representation par sommets (coordonnees x et y) est utilisee

Q = Polyhedron([-2, -0.5; 2, -2; 4, 1.2; -3, 1; 0, 2.5; 4 -0.5]);

figure(1)
[V, P] = mpt_voronoi(points','bound', Q); %% V contient les n regions de Voronoi V1,...,Vn 
plot(V)
hold on
%% Affichage des generateurs
for i=1:n
    plot(points(i,1),points(i,2),'k.')
    text(points(i,1),points(i,2),['  ',num2str(i)],...
    'VerticalAlignment','middle','FontSize',10)    
end
title('Diagramme de Voronoï généré par la fonction "mpt\_voronoi"')
axis equal
grid off

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Utilisation de la fonction standard de Matlab "voronoi" %%%

figure(2)
voronoi(points(:,1),points(:,2))
xlabel('x_1')
ylabel('x_2')
axis equal
title('Diagramme de Voronoï généré par la fonction "voronoi"')
