%% Generation des trajectoires du robot %%
%%
%% 'Cmd': application parfaite de la commande
%% 'Done': commande bruitee
%% 'Odom': par odometrie (bruits sur la commande et les capteurs)

vCmd = zeros(1, nbIter) + vmoy;
k = 1:nbIter;
nSteps = nbIter;
wCmd = braqAngleMax*pi/180*sin(3*pi*k/nSteps);

xCmd(1) = 0;
yCmd(1) = 0;
thetaCmd(1) = 0;

for i=1:nbIter
    thetaCmd(i+1) = thetaCmd(i) + wCmd(i);
    xCmd(i+1) = xCmd(i) + vCmd(i)*cos(thetaCmd(i+1));
    yCmd(i+1) = yCmd(i) + vCmd(i)*sin(thetaCmd(i+1));
end

plot(xCmd,yCmd,'b','LineWidth', 2);

% Bruits sur la commande
vDone = vCmd+(rand(1,nbIter)-0.5)*2.0*sigmav;
wDone = wCmd+(rand(1,nbIter)-0.5)*2.0*sigmaw;

xDone(1) = 0;
yDone(1) = 0;
thetaDone(1) = 0;

for i=1:nbIter
    thetaDone(i+1) = thetaDone(i) + wDone(i);
    xDone(i+1) = xDone(i) + vDone(i)*cos(thetaDone(i+1));
    yDone(i+1) = yDone(i) + vDone(i)*sin(thetaDone(i+1));
end

plot(xDone,yDone,'g','LineWidth', 2);

% Bruit sur les capteurs 
vOdom = vDone+(rand(1,nbIter)-0.5)*2.0*sigmaT;
wOdom = wDone+(rand(1,nbIter)-0.5)*2.0*sigmaR;

phipg = (vOdom-demiL*wOdom)/r;
phipd = -(demiL*wOdom + vOdom)/r;

phig = [0 cumsum(phipg)];
phid = [0 cumsum(phipd)];

axis equal

title('Trajectoires du robot unicycle')
xlabel('x [mm]')
ylabel('y [mm]')

clear phipg phipd vOdom wOdom vDone wDone
