function SIGMApp = propageErreurs(SIGMAp, delta_sg, delta_sd, theta, L, kg, kd)

delta_s = (delta_sd + delta_sg)/2;
delta_theta = (delta_sd - delta_sg)/L;

SIGMAdelta = [kd*abs(delta_sd)         0;
                     0         kg*abs(delta_sg)];

nabla_f_p = [1  0 -delta_s*sin(theta + delta_theta/2);
             0  1  delta_s*cos(theta + delta_theta/2);
             0  0                   1                ];

nabla_f_Ddg11 = 0.5*cos(theta + delta_theta/2) - (delta_s/(2*L))*sin(theta + delta_theta/2);
nabla_f_Ddg12 = 0.5*cos(theta + delta_theta/2) + (delta_s/(2*L))*sin(theta + delta_theta/2);
nabla_f_Ddg21 = 0.5*sin(theta + delta_theta/2) + (delta_s/(2*L))*cos(theta + delta_theta/2);
nabla_f_Ddg22 = 0.5*sin(theta + delta_theta/2) - (delta_s/(2*L))*cos(theta + delta_theta/2);
nabla_f_Ddg31 = 1/L;
nabla_f_Ddg32 = -1/L;

nabla_f_Ddg = [nabla_f_Ddg11, nabla_f_Ddg12; 
               nabla_f_Ddg21, nabla_f_Ddg22;
               nabla_f_Ddg31, nabla_f_Ddg32];

SIGMApp = nabla_f_p*SIGMAp*nabla_f_p' + nabla_f_Ddg*SIGMAdelta*nabla_f_Ddg';

