%% Localisation et Navigation de Robots - TD1 %%

clc
clear all
close all

addpath('outils/')

nbIter = 100; % Nombre d'instants de la simulation

figure(1) % Figure pour afficher tous les resultats
clf
hold on

% Initialisation des scripts 
initRobot;          % Pour les dimensions du robot (r est le rayon d'une roue 
                    % et L est la longueur de l'essieu) et autres parametres
                    
initBruits;         % Pour les parametres des bruits sur la commande et des capteurs
                    
genereTrajs;        % Pour la generation de la trajectoire et  
                    % de phig et phid qui sont les mesures successives des 
                    % codeurs des roues (en radians)

% Initialisation de la pose du robot (en [mm])
xOdom(1) = 0;
yOdom(1) = 0;
thetaOdom(1) = 0;

% Matrice de covariance initiale
SIGMAp = 1e-4*eye(3);

% Calcul de l'ellipse d'incertitude a l'instant initial
[da1(1), da2(1), theta_e(1)] = extraitEllipse(SIGMAp);

for i=1:nbIter
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    diff_phig = phig(i+1)-phig(i);
    diff_phid = -(phid(i+1)-phid(i));
    
    delta_sg = diff_phig*r;
    delta_sd = diff_phid*r;

    %% Exercice 1 %%
    [xOdom(i+1), yOdom(i+1), thetaOdom(i+1)] = ...
    MAJEtatOdometrie(xOdom(i), yOdom(i), thetaOdom(i), delta_sg, delta_sd, L);
  
    %% Exercice 2 %%
    SIGMAp = propageErreurs(SIGMAp, delta_sg, delta_sd, thetaOdom(i), L, kg, kd);

    %% Exercice 3 %% 
    [da1(i+1), da2(i+1), theta_e(i+1)] = extraitEllipse(SIGMAp);
    
    if mod(i,5) == 0
       drawellipse([xOdom(i+1), yOdom(i+1), theta_e(i+1)], 3*sqrt(da1(i+1)), 3*sqrt(da2(i+1)), 'k');
       plot(xOdom(i+1), yOdom(i+1),'k.','MarkerSize',14)
    end
                  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
     %% Affiche les positions successives du robot
     % drawrobot([xDone(i) yDone(i) thetaDone(i)], 'k', 4, 250, 300);
     plot(xOdom,yOdom, 'r', 'LineWidth', 2);
     pause(0.02)
end

hold off
axis equal

title('Trajectoires du robot unicycle')
legend(' Application parfaite de la commande',...
       ' Reelle (commande bruitee)',...
       ' Obtenue par odometrie','Location','NorthWest');
xlabel('x [mm]')
ylabel('y [mm]')