function [v, H, SIGMAin] = appariement(zPredit, z, Pi, R, g)

for j=1:size(z,2)
    dM_max = 1e10;
    dM = dM_max;
    i = 1;
    while(i <= size(zPredit,2)) && (dM > g^2)
        % Matrice jacobienne de h^j
        Hj = [      0                  0             -1;
           -cos(zPredit(1,j))  -sin(zPredit(1,j))     0];
     
        % Innovation pour l'appariement candidat
        vij = z(:,i) - zPredit(:,j);
        
        % Calcul de la distance de Mahalanobis (au carré)
        SIGMAinij = Hj*Pi*Hj' + R(1+2*(i-1):1+2*(i-1)+1,1+2*(i-1):1+2*(i-1)+1);
        dM = vij' * inv(SIGMAinij) * vij;
        
        % Contribution a l'innovation et au jacobien composites
        if(dM < dM_max)
            dM_max = dM;
            v(1+2*(j-1):1+2*(j-1)+1) = vij;
            H(1+2*(j-1):1+2*(j-1)+1, :) = Hj;
        end
        
        i = i + 1;
    end
end
SIGMAin = H*Pi*H' + R; % Calcul de la covariance de l'innovation composite
v = v';


