function [x, y, theta, P] = correction(xi, yi, thetai, Pi, a_d, r_d, a_d_o, r_d_o, g)

% alpha_droites -> a_d
% r_droites -> r_d
% alpha_droites_obs -> a_d_o
% r_droites_obs -> r_d_o

% Observation
z = [a_d_o ; r_d_o];
R = zeros(2*length(a_d_o),2*length(a_d_o));

% Bruit sur la perception exteroceptive. Variances sur la diagonale de la
% matrice R^j_t: sigma_aa = 2.5*pi/180, sigma_rr = 10

for i=1:length(a_d_o)
    R(1+2*(i-1):1+2*(i-1)+1, 1+2*(i-1):1+2*(i-1)+1) = [2.5*pi/180 0; 0 10]; 
end                                                                         

% Prediction de mesure
zPredit = predictionDeMesure(a_d, r_d, xi, yi, thetai);

% Appariement
[v, H, SIGMAin] = appariement(zPredit, z, Pi, R, g);

% Estimation
[x, y, theta, P] = estimation(xi, yi, thetai, Pi, v, H, SIGMAin);




