function [x, y, theta, P] = estimation(xi, yi, thetai, Pi, v, H, SIGMAin)

% Calcul du gain de Kalman
K = Pi * H' * inv(SIGMAin);

% Estimation de l'etat
X = [xi, yi, thetai]' + K * v;

% Estimation de l'incertitude de l'etat
P = Pi - K * SIGMAin * K';

% Mise en forme
x = X(1);
y = X(2);
theta = X(3);

if(theta < 0)
    theta = theta + 2*pi;
end

