%% Generation des trajectoires du robot 
%%
%% 'Cmd': application parfait de la commande
%% 'Done': commande bruitee
%% 'Odom': par odometrie (bruits sur la commande et capteurs)

vCmd = zeros(1, nbIter) + vmoy;
k = 1:nbIter;
nSteps = nbIter;
wCmd = braqAngleMax*pi/180*sin(3*pi*k/nSteps);

xCmd(1) = 0;
yCmd(1) = 0;
thetaCmd(1) = 0;

for i=1:nbIter
    thetaCmd(i+1) = thetaCmd(i) + wCmd(i);
    xCmd(i+1) = xCmd(i) + vCmd(i) * cos(thetaCmd(i+1));
    yCmd(i+1) = yCmd(i) + vCmd(i) * sin(thetaCmd(i+1));
end

hl(2) = plot(xCmd,yCmd, 'LineWidth', 3); 

% bruits sur la commande
vDone = vCmd+(rand(1,nbIter)-0.5)*2*sigmav;
wDone = wCmd+(rand(1,nbIter)-0.5)*2*sigmaw;

xDone(1) = 0;
yDone(1) = 0;
thetaDone(1) = 0;

alpha_droites_obs(1,:) = alpha_droites;
r_droites_obs(1,:) = r_droites;

for i=1:nbIter
    thetaDone(i+1) = thetaDone(i) + wDone(i);
    xDone(i+1) = xDone(i) + vDone(i) * cos(thetaDone(i+1));
    yDone(i+1) = yDone(i) + vDone(i) * sin(thetaDone(i+1));
    
    % Perception exteroceptive
    for j=1:length(alpha_droites)
        alpha_droites_obs(i, j) = alpha_droites(j) - thetaDone(i+1);
        if(alpha_droites_obs(i, j) < 0)
            alpha_droites_obs(i, j) = alpha_droites_obs(i, j) + 2.0*pi;
        end
        r_droites_obs(i, j) = r_droites(j) - (xDone(i+1)*cos(alpha_droites(j)) + yDone(i+1)*sin(alpha_droites(j)));
    end
    [alpha_droites_obs(i,:), I] = sort(alpha_droites_obs(i,:), 2, 'ascend');
    r_droites_obs(i, :) = r_droites_obs(i, I);
    % Reclassement des droites percues en fonction de leur angle (pour que
    % l'appariement ne soit pas deja fait avant l'heure ...)
end

hl(3) =  plot(xDone,yDone, 'g', 'LineWidth', 3);

% Bruit sur les capteurs 
vOdom = vDone+(rand(1,nbIter)-0.5)*2*sigmaT;
wOdom = wDone+(rand(1,nbIter)-0.5)*2*sigmaR;

phipg = (vOdom-demiL*wOdom)/r;
phipd = -(demiL*wOdom + vOdom)/r;

phig = [0 cumsum(phipg)];
phid = [0 cumsum(phipd)];

clear phipg phipd vOdom wOdom vDone wDone
