function [x, y, theta, P] = prediction(xi, yi, thetai, Pi, delta_sg, delta_sd, L, kg, kd)

delta_s = (delta_sg + delta_sd)/2;
delta_theta = (delta_sd - delta_sg)/L;

theta = thetai + delta_theta;
if theta < 0
   theta = theta + 2*pi;
end
x = xi + delta_s*cos(thetai + delta_theta/2);
y = yi + delta_s*sin(thetai + delta_theta/2);

Q = [kd*abs(delta_sd)       0;
           0         kg*abs(delta_sg)];

Fx = [ 1  0 -delta_s*sin(thetai + delta_theta/2);
       0  1  delta_s*cos(thetai + delta_theta/2);
       0  0                   1                 ];

Fu = [ 0.5*cos(thetai + delta_theta/2) - (delta_s/2*L)*sin(thetai + delta_theta/2), ...
               0.5*cos(thetai + delta_theta/2) + (delta_s/(2*L))*sin(thetai + delta_theta/2);
               
       0.5*sin(thetai + delta_theta/2) + (delta_s/2*L)*cos(thetai + delta_theta/2), ...
               0.5*sin(thetai + delta_theta/2) - (delta_s/(2*L))*cos(thetai + delta_theta/2)
                        
       1/L, -1/L ];
   
P = Fx*Pi*Fx' + Fu*Q*Fu';
