%% Localisation et Navigation de Robots - TD2 %%

clear all
close all
clc

addpath('outils/')

nbIter = 100; % Nombre d'instants de la simulation

figure(1)
clf
hold on

initEnviro;  % Initialise le modele de l'environnement, a savoir l'ensemble des
             % droites le modelisant dans le repere global

initRobot;   % Initialise les parametres du robot

initBruits;  % Parametres des bruits pour simuler une commande mal 
             % appliquee et pour simuler l'incertitude des odometres

genereTrajs; % Genration de la trajectoire du robot s'il applique 
             % parfaitement la commande
             % Generation des droites qui delimitent l'environnement
             % Generation de la trajectoire reelle du robot (commande bruitee)

% phig et phid sont les mesures successives des codeurs des roues (en radians)

% alpha_droites_obs et r_droites_obs sont les mesures issues de la
% perception exteroceptive : les parametres des quatre droites percues,
% centres au repere du robot et ordonnes selon l'angle (en premier, la
% droite percue face au robot, puis les autres en tournant dans le sens antihoraire)

% r est le rayon d'une roue
% L est la longueur de l'essieu

% Initialisation pose vrai et estimee du robot

xOdom(1) = 0;
yOdom(1) = 0;
thetaOdom(1) = 0;

xEstime(1) = 0;
yEstime(1) = 0;
thetaEstime(1) = 0;

PEstime = 1e-4*eye(3);

g = 1; %% Parametre pour l'appariement 

for i=1:nbIter
    
    diff_phig = phig(i+1)-phig(i);
    diff_phid = -(phid(i+1)-phid(i));
    
    delta_sg = diff_phig*r;
    delta_sd = diff_phid*r;
    
    % Pour la comparaison des resultats
    [xOdom(i+1), yOdom(i+1), thetaOdom(i+1)] = ...
        MAJEtatOdometrie(xOdom(i), yOdom(i), thetaOdom(i), delta_sg, delta_sd, L);
    
    % 1. Mise a jour de la configuration du robot mobile par prediction
    [xPredit, yPredit, thetaPredit, PPredit] = ...
        prediction(xEstime(i), yEstime(i), thetaEstime(i), PEstime, delta_sg, delta_sd, L, kg, kd);
        
    % 2. Mise a jour par correction
    [xEstime(i+1), yEstime(i+1), thetaEstime(i+1), PEstime] = ...
        correction(xPredit, yPredit, thetaPredit, PPredit, alpha_droites, r_droites, ... 
        alpha_droites_obs(i,:), r_droites_obs(i,:), g);
    
    %%%%%%%%%%
        
    %     [da1, da2, theta_e] = extraitEllipse(PEstime);
    %
    %     if mod(i,5) == 0
    %        drawellipse([xEstime(i+1), yEstime(i+1), theta_e], 3*sqrt(da1), 3*sqrt(da2), 'k');
    %        plot(xEstime(i+1), yEstime(i+1),'k.','MarkerSize',14)
    %     end
       
end
hl(4) = plot(xEstime,yEstime, 'k', 'LineWidth', 3);
hl(5) = plot(xOdom,yOdom, 'r', 'LineWidth', 3);

hold off
axis equal
axis([xmin xmax ymin ymax])
title('Trajectoires du robot unicycle')
xlabel('x [mm]')
ylabel('y [mm]')

h = legend(hl, ...
        ' Droites de l''environnement', ...
        ' Application parfaite de la commande', ...
        ' Reelle (commande bruitee)', ... 
        ' Obtenue par EKF', ...
        ' Obtenue par odometrie','Location','NorthWest');
set(h,'FontSize',10);
