%% Localisation et Navigation de Robots - TD1 %%

clear all
close all
clc

addpath('outils/')

nbIter = 100; %% Nombre d'instants de la simulation

figure(1)
clf
hold on

initRobot;
initBruits;
genereTrajs;

% phig et phid sont les mesures successives des codeurs des roues (en radians)

% r est le rayon d'une roue
% L est la longueur de l'essieu

% Initialisation de la position du robot (en [mm])

xOdom(1) = 0.0;
yOdom(1) = 0.0;
thetaOdom(1) = 0.0;

for i=1:nbIter 
    
     % Affiche les positions successives du robot 
     drawrobot([xDone(i) yDone(i) thetaDone(i)], 'k', 4, 250, 300);
     pause(0.02)
end
plot(xOdom,yOdom, 'r', 'LineWidth', 2)
hold off
axis equal

title('Trajectoires du robot unicycle')
legend(' Application parfaite de la commande',...
           ' Reelle (commande bruitee)',...
           ' Obtenue par odometrie','Location','NorthWest');
xlabel('x [mm]')
ylabel('y [mm]')