% Initialise le modele de l'environnement, c'est-a-dire l'ensemble 
% des droites le modelisant dans le repere global

xmin = -1000;
xmax = 6000;
ymin = -1000;
ymax = 4000;

alpha_droites = [-pi/2, 0.0, pi/2, pi];
r_droites = [500, 5500, 3500, 500];

for i=1:length(alpha_droites)
    if(alpha_droites(i) < 0)
        alpha_droites(i) = alpha_droites(i) + 2*pi;
    end
    
    if(abs(alpha_droites(i)) == pi/2)
        he = plot([xmin xmax],[sign(alpha_droites(i))*r_droites(i) sign(alpha_droites(i))*r_droites(i)], 'k--');
    else if(abs(alpha_droites(i)) == pi) || (abs(alpha_droites(i)) == 0)
        he = plot([-sign(alpha_droites(i)-pi/2.0)*r_droites(i) -sign(alpha_droites(i)-pi/2.0)*r_droites(i)], [ymin ymax], 'k--');
        else 
            he = plot([xmin xmax], [(r_droites(i)-xmin*cos(alpha_droites(i)))/sin(alpha_droites(i)) ...
                 (r_droites(i)-xmax*cos(alpha_droites(i)))/sin(alpha_droites(i))], 'k--');
        end
    end
    
end

hl(1) = he;
