%% Localisation et Navigation de Robots - TD2 %%

clear all
close all
clc

addpath('outils/')

nbIter = 100; % Nombre d'instants de la simulation

figure(1)
clf
hold on

initEnviro;  % Initialise le modele de l'environnement, c'est-a-dire l'ensemble 
             % des droites le modelisant dans le repere global
            
initRobot;   % Initialise les parametres du robot

initBruits;  % Parametres des bruits pour simuler une commande mal 
             % appliquee et pour simuler l'incertitude des odometres
            
genereTrajs; % Generation de la trajectoire du robot s'il applique 
             % parfaitement la commande
             % Generation des droites qui delimitent l'environnement
             % Generation de la trajectoire reelle du robot (commande bruitee)

% phig et phid sont les mesures successives des codeurs des roues (en radians)

% alpha_droites_obs et r_droites_obs sont les mesures issues de la
% perception exteroceptive : les parametres des quatre droites percues,
% centres au repere du robot et ordonnes selon l'angle (en premier, la
% droite percue face au robot, puis les autres en tournant dans le sens antihoraire)

% r est le rayon d'une roue
% L est la longueur de l'essieu

xOdom(1) = 0;
yOdom(1) = 0;
thetaOdom(1) = 0;

xEstime(1) = 0;
yEstime(1) = 0;
thetaEstime(1) = 0;

PEstime = 1e-4*eye(3);

for i=1:nbIter

    diff_phig = phig(i+1)-phig(i);
    diff_phid = -(phid(i+1)-phid(i));
    
    delta_sg = diff_phig*r;
    delta_sd = diff_phid*r;
    
    % Position calculee par odometrie, pour faire la comparaison des resultats  
    % (fonction deja vue dans le TD1)
    [xOdom(i+1), yOdom(i+1), thetaOdom(i+1)] = ...
        MAJEtatOdometrie(xOdom(i), yOdom(i), thetaOdom(i), delta_sg, delta_sd, L);
    
    % -- 1. Phase de Prediction -- 
    %
    % La fonction groupe les deux fonctions du TD1: "MAJEtatOdometrie" pour
    % la prediction de pose et "propageErreurs" pour le calcul de la matrice de covariance

    % --> [....]
    
    % -- 2. Phase de correction (mise a jour de la pose du robot) --
    
    % --> [....]
    
end
hl(4) = plot(xEstime,yEstime, 'k', 'LineWidth', 3);
hl(5) = plot(xOdom,yOdom, 'r', 'LineWidth', 3);

% hold off
% axis equal
% axis([xmin xmax ymin ymax])
% title('Trajectoires du robot unicycle')
% xlabel('x [mm]')
% ylabel('y [mm]')
%  
% h = legend(hl, ...
%         ' Droites de l''environnement', ...
%         ' Application parfaite de la commande', ...
%         ' Reelle (commande bruitee)', ... 
%         ' Obtenue par EKF', ...
%         ' Obtenue par odometrie','Location','NorthWest');
% set(h,'FontSize',10);
