%%%% The function "Plot_robot" displays a robot as a triangle 

%%%% Input arguments:
%%%%
%%%% - (X,Y,theta): vectors of the time-indexed positions and orientations (in radians) of the robot
%%%% - Step: how frequently the robot is displayed (every Step*Tc seconds, where Tc is the sampling time)
%%%% - Color: color of the robot, as in the standard plot function (e.g. 'r' for red, 'k' for black, etc.)
%%%% - Scale: size of the robot (default value: 0.035)

function Plot_robot(X,Y,theta,step,color,scale)

if nargin == 5
   scale=0.035;
end

robot = scale*[-10,10,0,-10; -17,-17,20,-17; 1,1,1,1];
        
for i = 1:length(X)
    if mod(i,step) == 0
       R10 = [cos(theta(i)-pi/2),-sin(theta(i)-pi/2),0;
              sin(theta(i)-pi/2),cos(theta(i)-pi/2) ,0;
                  0        ,      0       ,1];
       r_robot = R10*robot;
       Xr(:,1) = r_robot(:,1) + [X(i);Y(i);0];
       Xr(:,2) = r_robot(:,2) + [X(i);Y(i);0];
       Xr(:,3) = r_robot(:,3) + [X(i);Y(i);0];
       Xr(:,4) = r_robot(:,4) + [X(i);Y(i);0];
       plot(Xr(1,:),Xr(2,:),color);
    end
end