#include <Aria.h>

int main(int argc, char** argv)
{
 
  // This object parses program options from the command line
  ArArgumentParser parser(&argc, argv);

  // Load some default values for command line arguments from /etc/Aria.args
  // (Linux) or the ARIAARGS environment variable.
  parser.loadDefaultArguments();

  // Central object that is an interface to the robot and its integrated
  // devices, and which manages control of the robot by the rest of the program.
  //a- Definition du robot
  printf("Robot definition \n")   ;
  ArRobot robot;
   
  // Object that connects to the robot or simulator using program options
  ArRobotConnector robotConnector(&parser, &robot);

  // Connect to the robot, get some initial data from it such as type and name,
  // and then load parameter files for this robot.
  if (!robotConnector.connectRobot())
  {
    // Error connecting:
    // if the user gave the -help argumentp, then just print out what happened,
    // and continue so options can be displayed later.
    if (!parser.checkHelpAndWarnUnparsed())
    {
      ArLog::log(ArLog::Terse, "Could not connect to robot, will not have parameter file so options displayed later may not include everything");
    }
    // otherwise abort
    else
    {
      ArLog::log(ArLog::Terse, "Error, could not connect to robot.");
      Aria::logOptions();
      Aria::exit(1);
    }
  }

  if(!robot.isConnected())
  {
    ArLog::log(ArLog::Terse, "Internal error: robot connector succeeded but ArRobot::isConnected() is false!");
  }

   // Parse the command line options. Fail and print the help message if the parsing fails
  // or if the help was requested with the -help option
  if (!Aria::parseArgs() || !parser.checkHelpAndWarnUnparsed())
  {    
    Aria::logOptions();
    Aria::exit(1);
    return 1;
  }
    //b- Initialisation du contexte
    printf("Aria Initialisation \n");
	Aria::init();
 
    //c- Definition capteur : Sonar
	printf("Sonar sensor definition \n") ;
    ArSonarDevice sonar;
       
    //d- Definition des actions du robot
	printf("Actions definition \n");
	ArActionAvoidFront action_avoidFront;
	ArActionAvoidSide action_avoidSide;
	ArActionConstantVelocity action_constantVelocity("Constant Velocity", 400);

    //e- Ajout du capteur sur le robot
    printf("Sonar added to robot \n");
	robot.addRangeDevice(&sonar);

    //f- Activation des moteurs et capteurs
	robot.comInt(ArCommands::ENABLE, 1);
	robot.comInt(ArCommands::SONAR, 1);

   	//g- Ajout d'actions du robot avec les priorites definies
	robot.addAction(&action_avoidFront, 100);		//priorite de 100
	robot.addAction(&action_avoidSide, 99);         //priorite de 99
	robot.addAction(&action_constantVelocity, 90);	//priorite de 90

    //h- Execution des comportements
    
    // To begin the processing cycle, call ArRobot::run() to enter the cycle synchronously, or ArRobot::runAsync() to run the cycle in a new background thread
	robot.run(true); // to return if it loses connection after which we exit the program
    //robot.runAsync(true); // run the ArRobot processing/task cycle thread

	// i- Attendre la fin de l'execution
	// Block execution of the main thread here and wait for the robot's task loop
	// thread to exit (e.g. by robot disconnecting, escape key pressed, or OS
	// signal)
	robot.waitForRunExit();
	
	// j- Fin du programme
	Aria::exit(0);
	
	return 0;
}
