%%% >> Perception Avancee et Robotique Mobile <<
%%% Regulation cartesienne d'un robot unicycle (AmigoBot)
%%%
%%% Pose initiale du robot: q0 = (x0,y0,theta0)
%%% Pose desiree: qd = (xd,yd,thetad) avec thetad libre
%%%
%%% Auteur: F. Morbidi 

close all
clear 
clc

%%% Duree de la simulation

Tf = 20; 

%%% Periode d'echantillonnage

Tc = 0.1;

%%% Pose initiale du robot: q0 = (x0,y0,theta0)

x0 = 0; 
y0 = 0; 
theta0 = 0; 

%%% Pose desiree (l'orientation finale thetad du robot est libre) 

xd = 1;
yd = 1;

%%% Gains du regulateur cartesien

k1 = 1; %% Gain sur la vitesse longitudinale du robot
k2 = 3; %% Gain sur la vitesse angulaire du robot

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Lancement de Simulink %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sim('RegCart_Simulink.slx')

%%% Affichage des resultats %%%

%%% Trajectoire du robot: (x,y,theta)

step = 1;       %% Affichage du robot, tous les step*Tc seconds
scale = 0.0013; %% Taille du robot

figure(1)
hold on
Plot_robot(q(:,1),q(:,2),q(:,3),step,'r',scale);
plot(q(1,1),q(1,2),'k.','MarkerSize',10)
plot(xd,yd,'k.','MarkerSize',12,'MarkerEdgeColor','b')
plot(q(:,1),q(:,2),'k')
xlabel('x [m]')
ylabel('y [m]')
title('Regulation cartesienne: Trajectoire du robot')
axis equal

%%% Evolution des entrees de commande du robot (v,w) dans le temps 

figure(2)
subplot(2,1,1)
plot(T,u(:,1),'b')
xlabel('Temps [s]')
ylabel('v(t) [m/s]')
title('Entrees de commande')
subplot(2,1,2)
plot(T,u(:,2),'b')
xlabel('Temps [s]')
ylabel('\omega(t) [rad/s]')
